/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.SacrificeSourceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CityOfTraitorsTriggeredAbility
extends TriggeredAbilityImpl {
    CityOfTraitorsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new SacrificeSourceEffect());
    }

    private CityOfTraitorsTriggeredAbility(CityOfTraitorsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent land = game.getPermanent(event.getTargetId());
        return land != null && land.isLand(game) && land.isControlledBy(this.controllerId) && !Objects.equals(event.getTargetId(), this.getSourceId());
    }

    public CityOfTraitorsTriggeredAbility copy() {
        return new CityOfTraitorsTriggeredAbility(this);
    }

    public String getRule() {
        return "When you play another land, sacrifice {this}.";
    }
}

