/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class ClackbridgeTrollEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledCreaturePermanent("creature to sacrifice");

    ClackbridgeTrollEffect() {
        super(Outcome.Benefit);
        this.staticText = "any opponent may sacrifice a creature. If a player does, tap {this}, you gain 3 life, and you draw a card.";
    }

    private ClackbridgeTrollEffect(ClackbridgeTrollEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClackbridgeTrollEffect copy() {
        return new ClackbridgeTrollEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        boolean flag = false;
        for (UUID opponentId : game.getOpponents(controller.getId())) {
            Permanent permanent;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            TargetControlledPermanent target = new TargetControlledPermanent(filter);
            target.withNotTarget(true);
            if (!target.canChoose(opponent.getId(), source, game) || !opponent.chooseUse(Outcome.AIDontUseIt, "Sacrifice a creature?", source, game) || !opponent.choose(Outcome.Sacrifice, (Target)target, source, game) || (permanent = game.getPermanent(target.getFirstTarget())) == null || !permanent.sacrifice(source, game)) continue;
            flag = true;
        }
        if (flag) {
            Permanent sourcePerm = source.getSourcePermanentIfItStillExists(game);
            if (sourcePerm != null) {
                sourcePerm.tap(source, game);
            }
            controller.gainLife(3, game, source);
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

