/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.AftermathAbility;
import mage.abilities.keyword.HasteAbility;
import mage.cards.CardSetInfo;
import mage.cards.SplitCard;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.SpellAbilityType;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetCreaturePermanent;

public final class ClaimFame
extends SplitCard {
    private static final FilterCard filter = new FilterCreatureCard("creature card with mana value 2 or less from your graveyard");

    public ClaimFame(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, new CardType[]{CardType.SORCERY}, "{B}", "{1}{R}", SpellAbilityType.SPLIT_AFTERMATH);
        this.getLeftHalfCard().getSpellAbility().addEffect((Effect)new ReturnFromGraveyardToBattlefieldTargetEffect());
        this.getLeftHalfCard().getSpellAbility().addTarget((Target)new TargetCardInYourGraveyard(filter));
        this.getRightHalfCard().addAbility(new AftermathAbility().setRuleAtTheTop(true));
        this.getRightHalfCard().getSpellAbility().addEffect((Effect)new BoostTargetEffect(2, 0, Duration.EndOfTurn).setText("target creature gets +2/+0"));
        this.getRightHalfCard().getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setText("and gains haste until end of turn"));
        this.getRightHalfCard().getSpellAbility().addTarget((Target)new TargetCreaturePermanent());
    }

    private ClaimFame(ClaimFame card) {
        super((SplitCard)card);
    }

    public ClaimFame copy() {
        return new ClaimFame(this);
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

