/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ClamavusEffect
extends ContinuousEffectImpl {
    ClamavusEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.BoostCreature);
        this.staticText = "each creature you control gets +1/+1 for each +1/+1 counter on it";
    }

    private ClamavusEffect(ClamavusEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ClamavusEffect copy() {
        return new ClamavusEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, source.getControllerId(), game);
        for (Permanent permanent : permanents) {
            int count = permanent.getCounters(game).getCount(CounterType.P1P1);
            if (count <= 0) continue;
            permanent.addPower(count);
            permanent.addToughness(count);
        }
        return true;
    }
}

