/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.ClayGolemCost;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ClayGolemEffect
extends OneShotEffect {
    ClayGolemEffect() {
        super(Outcome.Benefit);
        this.staticText = "monstrosity X, where X is the result";
    }

    private ClayGolemEffect(ClayGolemEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClayGolemEffect copy() {
        return new ClayGolemEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || permanent.isMonstrous()) {
            return false;
        }
        int monstrosityValue = source.getCosts().stream().filter(ClayGolemCost.class::isInstance).map(ClayGolemCost.class::cast).mapToInt(ClayGolemCost::getLastRoll).findFirst().orElse(0);
        permanent.addCounters(CounterType.P1P1.createInstance(monstrosityValue), source.getControllerId(), source, game);
        permanent.setMonstrous(true);
        game.fireEvent(GameEvent.getEvent((GameEvent.EventType)GameEvent.EventType.BECOMES_MONSTROUS, (UUID)source.getSourceId(), (Ability)source, (UUID)source.getControllerId(), (int)monstrosityValue));
        return true;
    }
}

