/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CleansingBeamEffect
extends OneShotEffect {
    CleansingBeamEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 2 damage to target creature and each other creature that shares a color with it";
    }

    private CleansingBeamEffect(CleansingBeamEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target != null) {
            ObjectColor color = target.getColor(game);
            target.damage(2, source, game);
            for (Permanent p : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game)) {
                if (target.getId().equals(p.getId()) || !p.getColor(game).shares(color)) continue;
                p.damage(2, source, game);
            }
            return true;
        }
        return false;
    }

    public CleansingBeamEffect copy() {
        return new CleansingBeamEffect(this);
    }
}

