/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class CleaverSkaabEffect
extends OneShotEffect {
    CleaverSkaabEffect() {
        super(Outcome.Benefit);
        this.staticText = "create two tokens that are copies of the sacrificed creature";
    }

    private CleaverSkaabEffect(CleaverSkaabEffect effect) {
        super((OneShotEffect)effect);
    }

    public CleaverSkaabEffect copy() {
        return new CleaverSkaabEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = CardUtil.castStream((Stream)source.getCosts().stream(), SacrificeTargetCost.class).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).findFirst().orElse(null);
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
        effect.setSavedPermanent(permanent);
        effect.setNumber(2);
        return effect.apply(game, source);
    }
}

