/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.TapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.DisturbAbility;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.DefendingPlayerControlsSourceAttackingPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class CleverDistraction
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature defending player controls");

    public CleverDistraction(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "");
        this.subtype.add((Object)SubType.AURA);
        this.color.setWhite(true);
        this.nightCard = true;
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        TriggeredAbilityImpl ability = new AttacksTriggeredAbility((Effect)new TapTargetEffect()).setTriggerPhrase("Whenever this creature attacks, ");
        ability.addTarget((Target)new TargetPermanent(filter));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAttachedEffect((Ability)ability, AttachmentType.AURA)));
        this.addAbility(DisturbAbility.makeBackAbility());
    }

    private CleverDistraction(CleverDistraction card) {
        super((CardImpl)card);
    }

    public CleverDistraction copy() {
        return new CleverDistraction(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)DefendingPlayerControlsSourceAttackingPredicate.instance);
    }
}

