/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DontUntapInControllersNextUntapStepTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ClingingMistsEffect
extends OneShotEffect {
    ClingingMistsEffect() {
        super(Outcome.Tap);
        this.staticText = "tap all attacking creatures. Those creatures don't untap during their controller's next untap step";
    }

    private ClingingMistsEffect(ClingingMistsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<Permanent> doNotUntapNextUntapStep = new ArrayList<Permanent>();
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_ATTACKING_CREATURES, source.getControllerId(), source, game)) {
            creature.tap(source, game);
            doNotUntapNextUntapStep.add(creature);
        }
        if (!doNotUntapNextUntapStep.isEmpty()) {
            DontUntapInControllersNextUntapStepTargetEffect effect = new DontUntapInControllersNextUntapStepTargetEffect("This creature");
            effect.setTargetPointer((TargetPointer)new FixedTargets(doNotUntapNextUntapStep, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }

    public ClingingMistsEffect copy() {
        return new ClingingMistsEffect(this);
    }
}

