/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.effects.common.counter.RemoveCounterTargetEffect;
import mage.cards.Card;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ClockspinningAddOrRemoveCounterEffect
extends OneShotEffect {
    ClockspinningAddOrRemoveCounterEffect() {
        super(Outcome.Removal);
        this.staticText = "Choose a counter on target permanent or suspended card. Remove that counter from that permanent or card or put another of those counters on it";
    }

    private ClockspinningAddOrRemoveCounterEffect(ClockspinningAddOrRemoveCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public ClockspinningAddOrRemoveCounterEffect copy() {
        return new ClockspinningAddOrRemoveCounterEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Counter selectCounterType(Game game, Ability source, Permanent permanent) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || permanent.getCounters(game).isEmpty()) return null;
        String counterName = null;
        if (permanent.getCounters(game).size() > 1) {
            ChoiceImpl choice = new ChoiceImpl(true);
            LinkedHashSet<String> choices = new LinkedHashSet<String>();
            for (Counter counter : permanent.getCounters(game).values()) {
                if (permanent.getCounters(game).getCount(counter.getName()) <= 0) continue;
                choices.add(counter.getName());
            }
            choice.setChoices(choices);
            choice.setMessage("Choose a counter type to add to " + permanent.getName());
            if (!controller.choose(Outcome.Neutral, (Choice)choice, game)) return null;
            counterName = choice.getChoice();
            return new Counter(counterName);
        } else {
            for (Counter counter : permanent.getCounters(game).values()) {
                if (counter.getCount() <= 0) continue;
                counterName = counter.getName();
            }
        }
        return new Counter(counterName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Counter selectCounterType(Game game, Ability source, Card card) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || card.getCounters(game).isEmpty()) return null;
        String counterName = null;
        if (card.getCounters(game).size() > 1) {
            ChoiceImpl choice = new ChoiceImpl(true);
            LinkedHashSet<String> choices = new LinkedHashSet<String>();
            for (Counter counter : card.getCounters(game).values()) {
                if (card.getCounters(game).getCount(counter.getName()) <= 0) continue;
                choices.add(counter.getName());
            }
            choice.setChoices(choices);
            choice.setMessage("Choose a counter type to add to " + card.getName());
            if (!controller.choose(Outcome.Neutral, (Choice)choice, game)) return null;
            counterName = choice.getChoice();
            return new Counter(counterName);
        } else {
            for (Counter counter : card.getCounters(game).values()) {
                if (counter.getCount() <= 0) continue;
                counterName = counter.getName();
            }
        }
        return new Counter(counterName);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (player != null && permanent != null) {
            if (player.chooseUse(Outcome.Neutral, "Remove a counter?", source, game)) {
                RemoveCounterTargetEffect effect = new RemoveCounterTargetEffect();
                effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
                effect.apply(game, source);
            } else {
                Counter counter = this.selectCounterType(game, source, permanent);
                if (counter != null) {
                    AddCountersTargetEffect effect = new AddCountersTargetEffect(counter);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
                    effect.apply(game, source);
                }
            }
            return true;
        }
        Card card = game.getCard(source.getFirstTarget());
        if (player != null && card != null) {
            if (player.chooseUse(Outcome.Neutral, "Remove a counter?", source, game)) {
                Counter counter = this.selectCounterType(game, source, card);
                RemoveCounterTargetEffect effect = new RemoveCounterTargetEffect(counter);
                effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
                effect.apply(game, source);
            } else {
                Counter counter = this.selectCounterType(game, source, card);
                if (counter != null) {
                    AddCountersTargetEffect effect = new AddCountersTargetEffect(counter);
                    effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
                    effect.apply(game, source);
                }
            }
            return true;
        }
        return false;
    }
}

