/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CloneShellDiesEffect
extends OneShotEffect {
    CloneShellDiesEffect() {
        super(Outcome.Benefit);
        this.staticText = "turn the exiled card face up. If it's a creature card, put it onto the battlefield under your control";
    }

    private CloneShellDiesEffect(CloneShellDiesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            List imprinted;
            Permanent permanent = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
            if (permanent != null && (imprinted = permanent.getImprinted()) != null && !imprinted.isEmpty()) {
                for (UUID imprintedId : imprinted) {
                    Card imprintedCard = game.getCard(imprintedId);
                    if (imprintedCard == null) continue;
                    imprintedCard.setFaceDown(false, game);
                    if (!imprintedCard.isCreature(game)) continue;
                    controller.moveCards(imprintedCard, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }

    public CloneShellDiesEffect copy() {
        return new CloneShellDiesEffect(this);
    }
}

