/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.IsPhaseCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.cost.SpellCostReductionSourceEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.c.ClosingStatementEffect;
import mage.constants.CardType;
import mage.constants.TargetController;
import mage.constants.TurnPhase;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetControlledCreaturePermanent;

public final class ClosingStatement
extends CardImpl {
    private static final FilterCreatureOrPlaneswalkerPermanent filter = new FilterCreatureOrPlaneswalkerPermanent("creature or planeswalker you don't control");

    public ClosingStatement(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{3}{W}{B}");
        IsPhaseCondition condition = new IsPhaseCondition(TurnPhase.END, true);
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.ALL, (Effect)new SpellCostReductionSourceEffect(2, (Condition)condition).setText("this spell costs {2} less to cast during your end step"));
        ability.addHint((Hint)new ConditionHint((Condition)condition, "On your end step"));
        ability.setRuleAtTheTop(true);
        this.addAbility((Ability)ability);
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)filter).setTargetTag(1));
        this.getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetControlledCreaturePermanent(0, 1).setTargetTag(2));
        this.getSpellAbility().addEffect((Effect)new ClosingStatementEffect());
    }

    private ClosingStatement(ClosingStatement card) {
        super((CardImpl)card);
    }

    public ClosingStatement copy() {
        return new ClosingStatement(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.NOT_YOU.getControllerPredicate());
    }
}

