/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class CloudhoofKirinEffect
extends OneShotEffect {
    CloudhoofKirinEffect() {
        super(Outcome.Detriment);
        this.staticText = "target player mill X cards, where X is that spell's mana value";
    }

    private CloudhoofKirinEffect(CloudhoofKirinEffect effect) {
        super((OneShotEffect)effect);
    }

    public CloudhoofKirinEffect copy() {
        return new CloudhoofKirinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            Player targetPlayer = null;
            for (Target target : source.getTargets()) {
                if (!(target instanceof TargetPlayer)) continue;
                targetPlayer = game.getPlayer(target.getFirstTarget());
            }
            int cmc = spell.getManaValue();
            if (targetPlayer != null && cmc > 0) {
                targetPlayer.millCards(cmc, source, game);
                return true;
            }
        }
        return false;
    }
}

