/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class CloudspireCoordinatorWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    CloudspireCoordinatorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent != null && (permanent.hasSubtype(SubType.MOUNT, game) || permanent.hasSubtype(SubType.VEHICLE, game))) {
            this.map.compute(permanent.getControllerId(), CardUtil::setOrIncrementValue);
        }
    }

    public void reset() {
        super.reset();
        this.map.clear();
    }

    static int getValue(Ability source, Game game) {
        return ((CloudspireCoordinatorWatcher)game.getState().getWatcher(CloudspireCoordinatorWatcher.class)).map.getOrDefault(source.getControllerId(), 0);
    }
}

