/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CoalstokeGearhulkEffect
extends OneShotEffect {
    public CoalstokeGearhulkEffect() {
        super(Outcome.Benefit);
        this.staticText = "At the beginning of your next end step, exile that creature.";
    }

    public CoalstokeGearhulkEffect(CoalstokeGearhulkEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoalstokeGearhulkEffect copy() {
        return new CoalstokeGearhulkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        ExileTargetEffect exileEffect = new ExileTargetEffect("At the beginning of your next end step, exile " + permanent.getLogName());
        exileEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect, TargetController.YOU);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
        return true;
    }
}

