/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;

class CobraTrapWatcher
extends Watcher {
    private Set<UUID> players = new HashSet<UUID>();

    public CobraTrapWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        StackObject spell;
        Permanent perm;
        if (event.getType() == GameEvent.EventType.DESTROYED_PERMANENT && (perm = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null && !perm.isCreature(game) && (spell = game.getStack().getStackObject(event.getSourceId())) != null && game.getOpponents(perm.getControllerId()).contains(spell.getControllerId())) {
            this.players.add(perm.getControllerId());
        }
    }

    public void reset() {
        super.reset();
        this.players.clear();
    }

    public boolean conditionMet(UUID playerId) {
        return this.players.contains(playerId);
    }
}

