/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class CodieVociferousCodexCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    CodieVociferousCodexCantCastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "you can't cast permanent spells";
    }

    private CodieVociferousCodexCantCastEffect(CodieVociferousCodexCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CodieVociferousCodexCantCastEffect copy() {
        return new CodieVociferousCodexCantCastEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Card card = game.getCard(event.getSourceId());
        return card != null && card.isPermanent(game);
    }
}

