/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ColfenorsPlansExileEffect
extends OneShotEffect {
    ColfenorsPlansExileEffect() {
        super(Outcome.DrawCard);
        this.staticText = "exile the top seven cards of your library face down";
    }

    private ColfenorsPlansExileEffect(ColfenorsPlansExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl toExile = new CardsImpl(controller.getLibrary().getTopCards(game, 7));
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            controller.moveCardsToExile(toExile.getCards(game), source, game, false, exileId, CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null));
            ExileZone exileZone = game.getExile().getExileZone(exileId);
            if (exileZone != null) {
                for (Card card : exileZone.getCards(game)) {
                    if (card == null) continue;
                    card.setFaceDown(true, game);
                }
            }
            return true;
        }
        return false;
    }

    public ColfenorsPlansExileEffect copy() {
        return new ColfenorsPlansExileEffect(this);
    }
}

