/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.DiscardCardCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.discard.DiscardCardYouChooseTargetEffect;
import mage.abilities.keyword.EscalateAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetOpponent;

public final class CollectiveBrutality
extends CardImpl {
    private static final FilterCard filter = new FilterCard("an instant or sorcery card");

    public CollectiveBrutality(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{1}{B}");
        this.addAbility((Ability)new EscalateAbility((Cost)new DiscardCardCost()));
        this.getSpellAbility().getModes().setMinModes(1);
        this.getSpellAbility().getModes().setMaxModes(3);
        this.getSpellAbility().addEffect((Effect)new DiscardCardYouChooseTargetEffect(filter));
        this.getSpellAbility().addTarget(new TargetOpponent().withChooseHint("reveals hand, you choose to discard"));
        Mode mode = new Mode((Effect)new BoostTargetEffect(-2, -2, Duration.EndOfTurn));
        mode.addTarget(new TargetCreaturePermanent().withChooseHint("gets -2/-2 until end of turn"));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new LoseLifeTargetEffect(2));
        mode.addEffect((Effect)new GainLifeEffect(2).concatBy("and"));
        mode.addTarget(new TargetOpponent().withChooseHint("loses 2 life"));
        this.getSpellAbility().addMode(mode);
    }

    private CollectiveBrutality(CollectiveBrutality card) {
        super((CardImpl)card);
    }

    public CollectiveBrutality copy() {
        return new CollectiveBrutality(this);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.INSTANT.getPredicate(), (Predicate)CardType.SORCERY.getPredicate()));
    }
}

