/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ColossalBadgerEffect
extends OneShotEffect {
    ColossalBadgerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature. Mill four cards, then put a +1/+1 counter on that creature for each creature card milled this way";
    }

    private ColossalBadgerEffect(ColossalBadgerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ColossalBadgerEffect copy() {
        return new ColossalBadgerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = player.millCards(4, source, game).count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (amount > 0 && permanent != null) {
            game.processAction();
            permanent.addCounters(CounterType.P1P1.createInstance(amount), source, game);
        }
        return true;
    }
}

