/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class ColossalGraveReaverEffect
extends OneShotEffect {
    private static final FilterCard defaultFilter = new FilterCard("creature to return to battlefield");

    public ColossalGraveReaverEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "put one of them onto the battlefield";
    }

    protected ColossalGraveReaverEffect(ColossalGraveReaverEffect effect) {
        super((OneShotEffect)effect);
    }

    public ColossalGraveReaverEffect copy() {
        return new ColossalGraveReaverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<Card> cardsToMove;
            CardsImpl cardsToChooseFrom = new CardsImpl();
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Card card = game.getCard(targetId);
                if (card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) continue;
                cardsToChooseFrom.add(card);
            }
            switch (cardsToChooseFrom.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    cardsToMove = new HashSet(cardsToChooseFrom.getCards(game));
                    break;
                }
                default: {
                    cardsToMove = new HashSet<Card>();
                    TargetCard target = new TargetCard(1, 1, Zone.ALL, defaultFilter);
                    target.withNotTarget(true);
                    controller.choose(Outcome.PlayForFree, (Cards)cardsToChooseFrom, target, source, game);
                    cardsToMove.add(cardsToChooseFrom.get(target.getFirstTarget(), game));
                }
            }
            controller.moveCards(cardsToMove, Zone.BATTLEFIELD, source, game, false, false, false, null);
            return true;
        }
        return false;
    }
}

