/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class CometStormEffect
extends OneShotEffect {
    CometStormEffect() {
        super(Outcome.Damage);
        this.staticText = "Choose any target, then choose another target for each time this spell was kicked. {this} deals X damage to each of them";
    }

    private CometStormEffect(CometStormEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int damage = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID uuid : this.getTargetPointer().getTargets(game, source)) {
                Permanent permanent = game.getPermanent(uuid);
                Player player = game.getPlayer(uuid);
                if (permanent != null) {
                    permanent.damage(damage, source.getSourceId(), source, game, false, true);
                }
                if (player == null) continue;
                player.damage(damage, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public CometStormEffect copy() {
        return new CometStormEffect(this);
    }
}

