/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class CommandeerEffect
extends OneShotEffect {
    CommandeerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Gain control of target noncreature spell. You may choose new targets for it. <i> (If that spell is an artifact, enchantment, or planeswalker, the permanent you control enters.)</i>";
    }

    private CommandeerEffect(CommandeerEffect effect) {
        super((OneShotEffect)effect);
    }

    public CommandeerEffect copy() {
        return new CommandeerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (controller != null && spell != null) {
            spell.setControllerId(controller.getId());
            spell.chooseNewTargets(game, controller.getId(), false, false, null);
            return true;
        }
        return false;
    }
}

