/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class CommunalBrewingCountersEffect
extends ReplacementEffectImpl {
    CommunalBrewingCountersEffect() {
        super(Duration.EndOfTurn, Outcome.BoostCreature);
        this.staticText = "that creature enters with X additional +1/+1 counters on it, where X is the number of ingredient counters on {this}";
    }

    private CommunalBrewingCountersEffect(CommunalBrewingCountersEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CommunalBrewingCountersEffect copy() {
        return new CommunalBrewingCountersEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        return spell != null && event.getTargetId().equals(spell.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent == null || creature == null) {
            return false;
        }
        creature.addCounters(CounterType.P1P1.createInstance(permanent.getCounters(game).getCount(CounterType.INGREDIENT)), source.getControllerId(), source, game, event.getAppliedEffects());
        return false;
    }
}

