/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CompellingDeterrenceEffect
extends OneShotEffect {
    CompellingDeterrenceEffect() {
        super(Outcome.Detriment);
        this.staticText = "return target nonland permanent to its owner's hand. Then that player discards a card if you control a Zombie";
    }

    private CompellingDeterrenceEffect(CompellingDeterrenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public CompellingDeterrenceEffect copy() {
        return new CompellingDeterrenceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        Player player = game.getPlayer(target.getControllerId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && player != null) {
            player.moveCards((Card)target, Zone.HAND, source, game);
            game.processAction();
            FilterPermanent zombieFilter = new FilterPermanent();
            zombieFilter.add((Predicate)SubType.ZOMBIE.getPredicate());
            if (game.getBattlefield().countAll(zombieFilter, controller.getId(), game) > 0) {
                player.discard(1, false, false, source, game);
            }
            return true;
        }
        return false;
    }
}

