/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class ConduitOfRuinWatcher
extends Watcher {
    private final Map<UUID, Integer> playerCreatureSpells = new HashMap<UUID, Integer>();

    public ConduitOfRuinWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = (Spell)game.getObject(event.getTargetId())) != null && spell.isCreature(game)) {
            this.playerCreatureSpells.put(event.getPlayerId(), this.creatureSpellsCastThisTurn(event.getPlayerId()) + 1);
        }
    }

    public int creatureSpellsCastThisTurn(UUID playerId) {
        return this.playerCreatureSpells.getOrDefault(playerId, 0);
    }

    public void reset() {
        super.reset();
        this.playerCreatureSpells.clear();
    }
}

