/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ConsignToDreamEffect
extends OneShotEffect {
    ConsignToDreamEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return target permanent to its owner's hand. If that permanent is red or green, put it on top of its owner's library instead";
    }

    private ConsignToDreamEffect(ConsignToDreamEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConsignToDreamEffect copy() {
        return new ConsignToDreamEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (target != null && controller != null) {
            if (target.getColor(game).isRed() || target.getColor(game).isGreen()) {
                return controller.putCardsOnTopOfLibrary((Card)target, game, source, true);
            }
            return controller.moveCards((Card)target, Zone.HAND, source, game);
        }
        return false;
    }
}

