/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceIsSpellCondition;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.CollectEvidenceCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class ConspiracyUnravelerInsteadEffect
extends ContinuousEffectImpl {
    private final AlternativeCostSourceAbility alternativeCastingCostAbility = new AlternativeCostSourceAbility((Cost)new CollectEvidenceCost(10), (Condition)SourceIsSpellCondition.instance);

    ConspiracyUnravelerInsteadEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You may collect evidence 10 rather than pay the mana cost for spells that you cast";
    }

    protected ConspiracyUnravelerInsteadEffect(ConspiracyUnravelerInsteadEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ConspiracyUnravelerInsteadEffect copy() {
        return new ConspiracyUnravelerInsteadEffect(this);
    }

    public void init(Ability source, Game game, UUID activePlayerId) {
        super.init(source, game, activePlayerId);
        this.alternativeCastingCostAbility.setSourceId(source.getSourceId());
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.getAlternativeSourceCosts().add(this.alternativeCastingCostAbility);
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

