/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.DiscoverEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class ContestOfClawsDamageEffect
extends OneShotEffect {
    ContestOfClawsDamageEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Target creature you control deals damage equal to its power to another target creature. If excess damage was dealt this way, discover X, where X is that excess damage.";
    }

    private ContestOfClawsDamageEffect(ContestOfClawsDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public ContestOfClawsDamageEffect copy() {
        return new ContestOfClawsDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent ownCreature = game.getPermanent(source.getFirstTarget());
        Permanent targetCreature = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (ownCreature == null || targetCreature == null) {
            return false;
        }
        int excess = targetCreature.damageWithExcess(ownCreature.getPower().getValue(), ownCreature.getId(), source, game);
        if (excess > 0) {
            Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> DiscoverEffect.doDiscover((Player)player, (int)excess, (Game)game, (Ability)source));
        }
        return true;
    }
}

