/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ConundrumSphinxEffect
extends OneShotEffect {
    ConundrumSphinxEffect() {
        super(Outcome.DrawCard);
        this.staticText = "each player chooses a card name. Then each player reveals the top card of their library. If the card a player revealed has the name they chose, that player puts it into their hand. If it doesn't, that player puts it on the bottom of their library";
    }

    private ConundrumSphinxEffect(ConundrumSphinxEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || sourceObject == null) {
            return false;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.getLibrary().hasCards()) continue;
            String cardName = ChooseACardNameEffect.TypeOfName.ALL.getChoice(player, game, source, false);
            Card card = player.getLibrary().getFromTop(game);
            if (card == null) continue;
            CardsImpl cards = new CardsImpl(card);
            player.revealCards(source, (Cards)cards, game);
            if (CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) {
                player.moveCards((Cards)cards, Zone.HAND, source, game);
                continue;
            }
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }

    public ConundrumSphinxEffect copy() {
        return new ConundrumSphinxEffect(this);
    }
}

