/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.DeliriumCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.OozeToken;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class ConvertToSlimeEffect
extends OneShotEffect {
    ConvertToSlimeEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy up to one target artifact, up to one target creature, and up to one target enchantment.<br>" + AbilityWord.DELIRIUM.formatWord() + "Then if there are four or more card types among cards in your graveyard, create an X/X green Ooze creature token, where X is the total mana value of permanents destroyed this way.";
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
    }

    private ConvertToSlimeEffect(ConvertToSlimeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ConvertToSlimeEffect copy() {
        return new ConvertToSlimeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int total = 0;
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || !permanent.destroy(source, game)) continue;
            total += permanent.getManaValue();
        }
        game.processAction();
        if (DeliriumCondition.instance.apply(game, source)) {
            new OozeToken(total, total).putOntoBattlefield(1, game, source);
        }
        return true;
    }
}

