/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CoralFightersEffect
extends OneShotEffect {
    CoralFightersEffect() {
        super(Outcome.Detriment);
        this.staticText = "look at the top card of defending player's library. You may put that card on the bottom of that player's library";
    }

    private CoralFightersEffect(CoralFightersEffect effect) {
        super((OneShotEffect)effect);
    }

    public CoralFightersEffect copy() {
        return new CoralFightersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Player defendingPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && defendingPlayer != null && (card = defendingPlayer.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl(card);
            controller.lookAtCards("Coral Fighters", (Cards)cards, game);
            if (controller.chooseUse(this.outcome, "Put that card on the bottom of its owner's library?", source, game)) {
                controller.moveCardToLibraryWithInfo(card, source, game, Zone.LIBRARY, false, false);
            } else {
                game.informPlayers(controller.getLogName() + " puts the card back on top of the library.");
            }
            return true;
        }
        return false;
    }
}

