/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class CorneredMarketReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent();

    public CorneredMarketReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, true, true);
        this.staticText = "Players can't cast spells with the same name as a nontoken permanent.<br> Players can't play nonbasic lands with the same name as a nontoken permanent.";
    }

    private CorneredMarketReplacementEffect(CorneredMarketReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE || event.getType() == GameEvent.EventType.PLAY_LAND;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent((GameEvent)event, (Game)game);
        if (spellAbility == null) {
            return false;
        }
        Card card = spellAbility.getCharacteristics(game);
        if (card != null) {
            Spell spell = game.getState().getStack().getSpell(event.getSourceId());
            if (spell != null && spell.isFaceDown(game)) {
                return false;
            }
            if (card.isLand(game) && !card.isBasic(game)) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                    if (permanent == null || !CardUtil.haveSameNames((MageObject)card, (String)permanent.getName(), (Game)game)) continue;
                    return true;
                }
                return false;
            }
            if (spell != null) {
                for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                    if (permanent == null || !CardUtil.haveSameNames((MageObject)card, (String)permanent.getName(), (Game)game)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public CorneredMarketReplacementEffect copy() {
        return new CorneredMarketReplacementEffect(this);
    }

    static {
        filter.add((Predicate)TokenPredicate.FALSE);
    }
}

