/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CorpseExplosionEffect
extends OneShotEffect {
    CorpseExplosionEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage equal to the exiled card's power to each creature and each planeswalker";
    }

    private CorpseExplosionEffect(CorpseExplosionEffect effect) {
        super((OneShotEffect)effect);
    }

    public CorpseExplosionEffect copy() {
        return new CorpseExplosionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int power = 0;
        for (Cost cost : source.getCosts()) {
            List exiledCards;
            if (!(cost instanceof ExileFromGraveCost) || (exiledCards = ((ExileFromGraveCost)cost).getExiledCards()).isEmpty()) continue;
            power = ((Card)exiledCards.get(0)).getPower().getValue();
            break;
        }
        if (power < 1) {
            return false;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT_CREATURE_OR_PLANESWALKER, source.getControllerId(), source, game)) {
            permanent.damage(power, source, game);
        }
        return true;
    }
}

