/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.ExileFromGraveCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.CorpseweftZombieToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class CorpseweftEffect
extends OneShotEffect {
    CorpseweftEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a tapped X/X black Zombie Horror creature token, where X is twice the number of cards exiled this way";
    }

    private CorpseweftEffect(CorpseweftEffect effect) {
        super((OneShotEffect)effect);
    }

    public CorpseweftEffect copy() {
        return new CorpseweftEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int amount = 0;
            for (Cost cost : source.getCosts()) {
                if (!(cost instanceof ExileFromGraveCost)) continue;
                amount = ((ExileFromGraveCost)cost).getExiledCards().size() * 2;
                new CreateTokenEffect((Token)new CorpseweftZombieToken(amount, amount), 1, true, false).apply(game, source);
            }
            if (amount > 0) {
                // empty if block
            }
        }
        return false;
    }
}

