/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.CorrosiveOozeCombatWatcher;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CorrosiveOozeEffect
extends OneShotEffect {
    CorrosiveOozeEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all Equipment attached to that creature at end of combat";
    }

    private CorrosiveOozeEffect(CorrosiveOozeEffect effect) {
        super((OneShotEffect)effect);
    }

    public CorrosiveOozeEffect copy() {
        return new CorrosiveOozeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CorrosiveOozeCombatWatcher watcher = (CorrosiveOozeCombatWatcher)game.getState().getWatcher(CorrosiveOozeCombatWatcher.class);
        if (watcher == null) {
            return false;
        }
        MageObjectReference sourceMor = new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game);
        List<Permanent> equipments = watcher.getEquipmentsToDestroy(sourceMor).stream().map(mor -> mor.getPermanent(game)).filter(Objects::nonNull).collect(Collectors.toList());
        watcher.getRelatedBlockedCreatures(sourceMor).stream().map(mor -> mor.getPermanent(game)).filter(Objects::nonNull).flatMap(p -> p.getAttachments().stream()).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(a -> a.hasSubtype(SubType.EQUIPMENT, game)).forEach(equipments::add);
        equipments.forEach(p -> p.destroy(source, game));
        return true;
    }
}

