/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CosmicHorrorEffect
extends OneShotEffect {
    CosmicHorrorEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy {this} unless you pay {3}{B}{B}{B}. If {this} is destroyed this way, it deals 7 damage to you";
    }

    private CosmicHorrorEffect(CosmicHorrorEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent cosmicHorror = source.getSourcePermanentIfItStillExists(game);
        if (controller != null && cosmicHorror != null) {
            ManaCostsImpl cost;
            if (controller.chooseUse(Outcome.Benefit, "Pay {3}{B}{B}{B} to prevent destroy effect?", source, game) && (cost = new ManaCostsImpl("{3}{B}{B}{B}")).pay(source, game, source, source.getControllerId(), false, null)) {
                return true;
            }
            if (cosmicHorror.destroy(source, game, false)) {
                controller.damage(7, source.getSourceId(), source, game);
                return true;
            }
        }
        return false;
    }

    public CosmicHorrorEffect copy() {
        return new CosmicHorrorEffect(this);
    }
}

