/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.ExileTargetForSourceEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CosmicInterventionReplacementEffect
extends ReplacementEffectImpl {
    CosmicInterventionReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "If a permanent you control would be put into a graveyard from the battlefield this turn, exile it instead. Return it to the battlefield under its owner's control at the beginning of the next end step";
    }

    private CosmicInterventionReplacementEffect(CosmicInterventionReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CosmicInterventionReplacementEffect copy() {
        return new CosmicInterventionReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (permanent = game.getPermanent(event.getTargetId())) != null && (card = game.getCard(event.getTargetId())) != null) {
            ExileTargetForSourceEffect exileEffect = new ExileTargetForSourceEffect();
            exileEffect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            exileEffect.apply(game, source);
            ReturnToBattlefieldUnderOwnerControlTargetEffect returnEffect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
            returnEffect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
            AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)returnEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zoneChangeEvent = (ZoneChangeEvent)event;
        if (zoneChangeEvent.isDiesEvent()) {
            Player controller = game.getPlayer(source.getControllerId());
            Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (permanent == null || controller == null || permanent.getControllerId() == controller.getId()) {
                return true;
            }
        }
        return false;
    }
}

