/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class CouncilOfTheAbsoluteCostReductionEffect
extends CostModificationEffectImpl {
    CouncilOfTheAbsoluteCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Spells with the chosen name you cast cost 2 less to cast";
    }

    protected CouncilOfTheAbsoluteCostReductionEffect(CouncilOfTheAbsoluteCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card card;
        if (abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && (card = game.getCard(abilityToModify.getSourceId())) != null) {
            String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
            return CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game);
        }
        return false;
    }

    public CouncilOfTheAbsoluteCostReductionEffect copy() {
        return new CouncilOfTheAbsoluteCostReductionEffect(this);
    }
}

