/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class CouncilOfTheAbsoluteReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    CouncilOfTheAbsoluteReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Your opponents can't cast spells with the chosen name";
    }

    private CouncilOfTheAbsoluteReplacementEffect(CouncilOfTheAbsoluteReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public CouncilOfTheAbsoluteReplacementEffect copy() {
        return new CouncilOfTheAbsoluteReplacementEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast a spell with that name (" + mageObject.getName() + " in play).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            MageObject object = game.getObject(event.getSourceId());
            String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
            return object != null && cardName != null && CardUtil.haveSameNames((MageObject)object, (String)cardName, (Game)game);
        }
        return false;
    }
}

