/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.choices.VoteHandler;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CouncilsJudgmentVote
extends VoteHandler<Permanent> {
    private final FilterPermanent filter;

    CouncilsJudgmentVote(Player controller) {
        this.filter = new FilterNonlandPermanent("nonland permanent not controlled by " + controller.getName());
        this.filter.add(Predicates.not((Predicate)new ControllerIdPredicate(controller.getId())));
    }

    protected Set<Permanent> getPossibleVotes(Ability source, Game game) {
        return new LinkedHashSet<Permanent>();
    }

    public Permanent playerChoose(String voteInfo, Player player, Player decidingPlayer, Ability source, Game game) {
        if (game.getBattlefield().count(this.filter, source.getControllerId(), source, game) < 1) {
            return null;
        }
        TargetPermanent target = new TargetPermanent(1, this.filter);
        target.withChooseHint(voteInfo + " (to exile)");
        target.withNotTarget(true);
        decidingPlayer.choose(Outcome.Exile, (Target)target, source, game);
        return game.getPermanent(target.getFirstTarget());
    }

    protected String voteName(Permanent vote) {
        return vote.getIdName();
    }
}

