/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCardTypePredicate;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.CardUtil;

class CounterlashEffect
extends OneShotEffect {
    CounterlashEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. You may cast a spell that shares a card type with it from your hand without paying its mana cost";
    }

    private CounterlashEffect(CounterlashEffect effect) {
        super((OneShotEffect)effect);
    }

    public CounterlashEffect copy() {
        return new CounterlashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        StackObject stackObject = game.getStack().getStackObject(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (stackObject == null || controller == null) {
            return false;
        }
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new SharesCardTypePredicate((Collection)stackObject.getCardType(game)));
        game.getStack().counter(source.getFirstTarget(), source, game);
        CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)controller.getHand()), (FilterCard)filter);
        return true;
    }
}

