/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CovenantOfMindsEffect
extends OneShotEffect {
    CovenantOfMindsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Reveal the top three cards of your library. Target opponent may choose to put those cards into your hand. If they don't, put those cards into your graveyard and draw five cards";
    }

    private CovenantOfMindsEffect(CovenantOfMindsEffect effect) {
        super((OneShotEffect)effect);
    }

    public CovenantOfMindsEffect copy() {
        return new CovenantOfMindsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (player == null || opponent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 3));
        if (!cards.isEmpty()) {
            player.revealCards(source, (Cards)cards, game);
            StringBuilder sb = new StringBuilder();
            sb.append("Put the revealed cards into ").append(player.getLogName()).append("'s hand?");
            sb.append(" If you don't, those cards are put into their graveyard and they will draw five cards.");
            if (opponent.chooseUse(Outcome.Neutral, sb.toString(), source, game)) {
                player.moveCards((Cards)cards, Zone.HAND, source, game);
            } else {
                player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
                player.drawCards(5, source, game);
            }
        } else if (!opponent.chooseUse(Outcome.Benefit, player.getLogName() + "'s library is empty? Do you want them to draw five cards?", source, game)) {
            player.drawCards(5, source, game);
        }
        return true;
    }
}

