/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CoverOfWinterEffect
extends PreventionEffectImpl {
    CoverOfWinterEffect() {
        super(Duration.WhileOnBattlefield, -1, true);
        this.staticText = "If a creature would deal combat damage to you and/or one or more creatures you control, prevent X of that damage, where X is the number of age counters on {this}";
    }

    private CoverOfWinterEffect(CoverOfWinterEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER || event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    protected PreventionEffectData preventDamageAction(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent != null) {
            return game.preventDamage(event, source, game, sourcePermanent.getCounters(game).getCount(CounterType.AGE));
        }
        this.discard();
        return game.preventDamage(event, source, game, 0);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.DAMAGE_PLAYER && event.getTargetId().equals(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        if (event.getType() == GameEvent.EventType.DAMAGE_PERMANENT && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isCreature(game) && permanent.isControlledBy(source.getControllerId())) {
            return super.applies(event, source, game);
        }
        return false;
    }

    public CoverOfWinterEffect copy() {
        return new CoverOfWinterEffect(this);
    }
}

