/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CovetedFalconEffect
extends OneShotEffect {
    CovetedFalconEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent gains control of any number of target permanents you control. Draw a card for each one they gained control of this way";
    }

    private CovetedFalconEffect(CovetedFalconEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetOpponentId = source.getFirstTarget();
        List targetPermanentIds = ((Target)source.getTargets().get(1)).getTargets();
        for (UUID permanentId : targetPermanentIds) {
            game.addEffect(new GainControlTargetEffect(Duration.Custom, true, targetOpponentId).setTargetPointer((TargetPointer)new FixedTarget(permanentId, game)), source);
        }
        game.processAction();
        int cardsToDraw = 0;
        for (UUID permanentId : targetPermanentIds) {
            Permanent permanent = game.getPermanent(permanentId);
            if (permanent == null || !permanent.isControlledBy(targetOpponentId)) continue;
            ++cardsToDraw;
        }
        new DrawCardSourceControllerEffect(cardsToDraw).apply(game, source);
        return true;
    }

    public CovetedFalconEffect copy() {
        return new CovetedFalconEffect(this);
    }
}

