/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CowedByWisdomayCostToAttackBlockEffect
extends PayCostToAttackBlockEffectImpl {
    CowedByWisdomayCostToAttackBlockEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, PayCostToAttackBlockEffectImpl.RestrictType.ATTACK_AND_BLOCK);
        this.staticText = "Enchanted creature can't attack or block unless its controller pays {1} for each card in your hand";
    }

    private CowedByWisdomayCostToAttackBlockEffect(CowedByWisdomayCostToAttackBlockEffect effect) {
        super((PayCostToAttackBlockEffectImpl)effect);
    }

    public ManaCosts getManaCostToPay(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && !controller.getHand().isEmpty()) {
            ManaCostsImpl manaCosts = new ManaCostsImpl();
            manaCosts.add((Object)new GenericManaCost(controller.getHand().size()));
            return manaCosts;
        }
        return null;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        return enchantment != null && enchantment.isAttachedTo(event.getSourceId());
    }

    public CowedByWisdomayCostToAttackBlockEffect copy() {
        return new CowedByWisdomayCostToAttackBlockEffect(this);
    }
}

