/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CracklingEmergenceEffect
extends ReplacementEffectImpl {
    CracklingEmergenceEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if enchanted land would be destroyed, instead sacrifice {this} and that land gains indestructible until end of turn";
    }

    private CracklingEmergenceEffect(CracklingEmergenceEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent enchantedPermanent = game.getPermanent(event.getTargetId());
        if (sourcePermanent == null || enchantedPermanent == null) {
            return false;
        }
        sourcePermanent.sacrifice(source, game);
        game.addEffect(new GainAbilityTargetEffect((Ability)IndestructibleAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(enchantedPermanent, game)), source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DESTROY_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        return sourcePermanent != null && event.getTargetId().equals(sourcePermanent.getAttachedTo());
    }

    public CracklingEmergenceEffect copy() {
        return new CracklingEmergenceEffect(this);
    }
}

