/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CraigBooneNovacGuardEffect
extends OneShotEffect {
    CraigBooneNovacGuardEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage equal to the number of quest counters on it to up to one target creature unless that creature's controller has {this} deal that much damage to them";
    }

    private CraigBooneNovacGuardEffect(CraigBooneNovacGuardEffect effect) {
        super((OneShotEffect)effect);
    }

    public CraigBooneNovacGuardEffect copy() {
        return new CraigBooneNovacGuardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (sourcePermanent == null || targetPermanent == null) {
            return false;
        }
        int amount = sourcePermanent.getCounters(game).getCount(CounterType.QUEST);
        Player playerChoosing = game.getPlayer(targetPermanent.getControllerId());
        if (playerChoosing != null && playerChoosing.chooseUse(Outcome.Neutral, "have " + amount + " damage be dealt to you instead of " + targetPermanent.getLogName() + "?", source, game)) {
            new DamageTargetEffect(amount).setTargetPointer((TargetPointer)new FixedTarget(playerChoosing.getId())).apply(game, source);
            return true;
        }
        new DamageTargetEffect(amount).setTargetPointer(this.getTargetPointer().copy()).apply(game, source);
        return true;
    }
}

