/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.MustBeBlockedByTargetSourceEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CrashingBoarsEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("untapped creature you control");

    CrashingBoarsEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player chooses an untapped creature they control. That creature blocks {this} this turn if able";
    }

    private CrashingBoarsEffect(CrashingBoarsEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrashingBoarsEffect copy() {
        return new CrashingBoarsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player defendingPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (defendingPlayer == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURE, defendingPlayer.getId(), source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURE);
        target.withNotTarget(true);
        defendingPlayer.choose(Outcome.Neutral, (Target)target, source, game);
        MustBeBlockedByTargetSourceEffect effect = new MustBeBlockedByTargetSourceEffect();
        effect.setTargetPointer((TargetPointer)new FixedTarget(target.getFirstTarget(), game));
        game.addEffect((ContinuousEffect)effect, source);
        return true;
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

