/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class CreditVoucherEffect
extends OneShotEffect {
    CreditVoucherEffect() {
        super(Outcome.Neutral);
        this.staticText = "Shuffle any number of cards from your hand into your library, then draw that many cards";
    }

    private CreditVoucherEffect(CreditVoucherEffect effect) {
        super((OneShotEffect)effect);
    }

    public CreditVoucherEffect copy() {
        return new CreditVoucherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            FilterCard filter = new FilterCard("card in your hand to shuffle away");
            TargetCardInHand target = new TargetCardInHand(0, controller.getHand().size(), filter);
            int amountShuffled = 0;
            if (target.canChoose(source.getControllerId(), source, game) && target.choose(Outcome.Neutral, source.getControllerId(), source.getSourceId(), source, game) && !target.getTargets().isEmpty()) {
                amountShuffled = target.getTargets().size();
                controller.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.LIBRARY, source, game);
            }
            controller.shuffleLibrary(source, game);
            if (amountShuffled > 0) {
                controller.drawCards(amountShuffled, source, game);
            }
            return true;
        }
        return false;
    }
}

